# Cuadro IV.2
# Intervalo de la diferencia de medias de poblaciones Normales

########################################################
# Seccin modificable por el usuario
########################################################
# Lectura de la base de datos
datos<-read.csv2("Cuadro IV.1.V.csv",encoding="latin1")

# Seleccin de las variables de inters
#varInteres<-c("Altura.cm")
varInteres<-c("Altura.cm","Peso.Kg")

# Seleccin de categorizacin de las variables
# Si no se utilizan variables de agrupacin obligatoriamente
# se exige que se coloce varAgrupacin como NULL
#varAgrupacion<-NULL
#varAgrupacion<-c("Sexo")
varAgrupacion<-c("Pas","Sexo")

# Seleccin de variables con los niveles deseados de
# comparacin.
# Si no se colocan niveles de comparacin se supone
# que la variable es binaria.
#varSel<-list("Sexo")
#varSel<-list("Sexo",c("Ciudad","3","4"))
varSel<-list(c("Ciudad","1","2"))

# Indique el nivel de significancia
alfa<-0.05

# Nombre del archivo de salida
ArchivodeSalida<-"Salida Cuadro IV.2.V.csv"



########################################################
# Seccin que realiza el procedimiento
########################################################

# Creacin de nuevas variables con los niveles propuestos.
w<-data.frame(row.names=1:dim(datos)[1])
varBin<-as.character()
for (i in 1:length(varSel)){
  nom<-varSel[[i]][1]
  x<-factor(datos[,nom])
  if (length(varSel[[i]])>1){
     sufijo<-paste(varSel[[i]][2:3],collapse="_")
     nom<-paste(nom,".",sufijo,sep="")
     x1<-factor(ifelse(x %in% varSel[[i]][2:3],as.character(x),NA))
     x1<-data.frame(factor(x1))
  }else{
     x1<-x
     x1<-data.frame(x)
  }
  names(x1)<-nom
  varBin<-c(varBin,nom)
  w<-data.frame(w,x1)
}

datos<-data.frame(datos,w)


# Verificacin de las variables de agrupacion binarias
# realmente lo son.
if (length(varBin)<1){
 stop("Debe al menos indicar una variable binaria")
 }else{
 sonbinarios<-sapply(1:length(varBin),function(i) if(length(table(datos[,varBin[i]]))!=2) return(1) else return(0))
}
if (sum(sonbinarios)!=0)  stop("Alguna variable no es binaria")

valores<-unlist(datos[,c(varInteres)])
variables<-factor(rep(varInteres,each=dim(datos)[1]))
agrupaciones<-data.frame(datos[rep(1:dim(datos)[1],length(varInteres)),c(varAgrupacion,varBin)])
names(agrupaciones)<-c(varAgrupacion,varBin)

datos2<-data.frame(agrupaciones,variable=variables,valor=valores)


# Funcin que recibe dos vectores y calcula el intervalo
# de confianza para la diferencia de medias y muestra
# si hay diferencia probando primero si las varianzas
# son iguales y utilizando el estadstico de acuerdo
# a este resultado.

difMedias<-function(l,alfa=0.05){
 x<-l[[1]][!is.na(l[[1]])]
 y<-l[[2]][!is.na(l[[2]])]
 n1<-length(x)
 n2<-length(y)
 m1<-mean(x)
 m2<-mean(y)
 diferencia<-m1-m2
 if ( n1< 2 | n2 < 2){
    r<-data.frame(n1=n1,n2=n2,
              media1=m1,media2=m2,
              limInf=NA,
              diferencia=m1-m2,
              limSup=NA,
              valorPMedia=NA,
              valorPVar=NA,
              varIgual=NA)
 }else{ 
 r1<-var.test(x,y,conf.level=1-alfa)
 varIgual<-(r1$p.value>=alfa)
 r2<-t.test(x,y,conf.level=1-alfa,var.equal=varIgual)
 r<-data.frame(n1=n1,n2=n2,
              media1=m1,media2=m2,
              limInf=r2$conf.int[1],
              diferencia=-diff(r2$estimate),
              limSup=r2$conf.int[2],
              valorPMedia=r2$p.value,
              valorPVar=r1$p.value,
              varIgual=varIgual)
 }
 return(r)
}


# Funcin para dividir en grupos binarios la lista de variables
dividegrupos<-function(i,l,vB) split(l[[i]]$valor,l[[i]][,vB])
listdiv<-function(i,l,vB) {
    nombres<-names(l[[i]])
    l2<-lapply(1:length(l[[i]]),dividegrupos,l[[i]],vB[i])
    names(l2)<-nombres
    return(l2)
}

if(!is.null(varAgrupacion)) lista1<-as.list(datos2[,c(varAgrupacion,"variable")]) else lista1<-datos2$variable
listaG<-lapply(1:length(varBin),function(i) split(datos2[,c(varBin[i],"valor")],lista1,drop=TRUE))
listaG1<-lapply(1:length(listaG),listdiv,listaG,varBin)
r<-lapply(1:length(listaG1),function(i) t(sapply(listaG1[[i]],difMedias)))
names(r)<-varBin



rFin<-r[[1]]
f1<-function(i){ rFin<<-rbind(rFin,r[[i]]) }
if (length(r)>=2) invisible(lapply(2:length(r),f1) )
t1<-as.data.frame.table(table(datos2[,c(varAgrupacion,"variable")]))
identif<-t1[t1$Freq>0,]
d<-dim(rFin)
n<-colnames(rFin)
rFin<-data.frame(matrix(unlist(rFin),d))
names(rFin)<-n
rFin<-data.frame(Tipo.de.Grupo=rep(names(r),each=dim(r[[1]])[1]),identif[rep(1:dim(identif)[1],length(r)),],rFin)
rFin<-rFin[with(rFin,n1!=0 | n2!=0),]
rFin$Resultado<-ifelse(rFin$valorPMedia>=alfa,"No signif dif de medias","Signif dif de medias")
rFin$Resultado[is.na(rFin$Resultado)]<-"Poco datos"
rFin$varIgual<-ifelse(rFin$varIgual==1,"Var no diferentes","Var diferentes")




########################################################
# Seccin que muestra los resultados
########################################################

rFin

if (!is.null(ArchivodeSalida)) write.csv2(data.frame(rFin),ArchivodeSalida,row.names=FALSE)



